%Note that the scripts in the Dependencies folder are required to run the
%script
clear
close all
%Directory to look for the raw data
file_dir=[pwd,'\'];
freq=1.065e6;
x_min=0;
x_max=1000;
x_vec=linspace(x_min,x_max,1e4);

h_fig=figure(1)       

file_list=dir(file_dir);
end_trace=length(file_list);
plot_on=true;
color={'r','r','r','r','r','r','r'};
expr='beam_ref';

plot_trace=false;

y_trace={};
x_trace={};
fig_no=2;

%Loads all the traces that matches the regular expression
%We here average the traces in a similar way to the other data analysis
for i=1:end_trace
    if ~file_list(i).isdir
        strobe_str=regexp(file_list(i).name,expr,'tokens');
        if~isempty(strobe_str) && file_list(i).bytes>1e4

            trace=load([file_dir,file_list(i).name]);
            
            %Separates the x and y data
            y_trace{end+1}=trace(:,2)/mean(trace(1:20,2));
            x_trace{end+1}=trace(:,1);
            
            %Plots each trace if the flag is on
            if plot_trace
                figure(fig_no)
                plot(trace(:,1),trace(:,2),'b');
                fig_no=fig_no+1;
                title(file_list(i).name,'Interpreter','none');
            end
        end
    end
end

figure(1)
ax=gca;
hold on

min_length=min(cellfun(@(x) length(x),y_trace));
x_mean=x_trace{1}(1:min_length);
y_mean=zeros(min_length,1);
n=length(x_trace);

%Averages the traces
for i=1:n
    y_mean=y_mean+y_trace{i}(1:min_length)/n;
end

%Normalizes the trace
y_mean=y_mean/(mean(y_mean(1:20)));

plot(x_mean,y_mean,'Color',rgb('light green'));
fitdata=fitArbFun('a*exp(-b*x)+c',x_mean,y_mean,'lower',[0,0,0],...
    'pIn',[1,1e-2,0],'upper',[1.1,1,1]);

plot(x_vec,fitdata(x_vec),'k','LineStyle',':','LineWidth',2)
Q=pi/fitdata.b*freq

%Plots and fits the strongly anti-damped trace
anti_damp=load([file_dir,'beam_anti_damping_24_1.0658MHz_m1.txt']);
anti_damp(:,2)=anti_damp(:,2)/mean(anti_damp(1:20,2));
fitdata_anti=fitArbFun('a*exp(-b*x)+c',anti_damp(:,1),anti_damp(:,2),'lower',[0,0,0],...
    'pIn',[1,1e-2,0],'upper',[1.1,1,1]);

anti_damp(:,2)=smooth(anti_damp(:,2),10);
plot(anti_damp(:,1),anti_damp(:,2),'Color',rgb('light red'));
plot(x_vec,fitdata_anti(x_vec),'Color','k','LineStyle',':','LineWidth',2);

plot(x_vec,fitdata(x_vec),'k','LineStyle',':')
Q=pi/fitdata.b*freq;

%Plots and fits the hypothesized 'damped' trace.
damp{1}=load([file_dir,'beam_damp_24_1.0658MHz_m1_damped.txt']);
damp{2}=load([file_dir,'beam_damp_24_1.0659MHz_m1_damped.txt']);

mean_damp=(damp{1}(:,2)+damp{2}(:,2))/2;
mean_damp=smooth(mean_damp,10)/mean(mean_damp(1:20));
fitdata_damp=fitArbFun('a*exp(-b*x)+c',damp{1}(:,1),mean_damp,'lower',[0,0,0],...
    'pIn',[1,1e-2,0],'upper',[1.1,1,1]);
plot(damp{1}(:,1),mean_damp,'Color',rgb('light blue'))
plot(x_vec,fitdata_damp(x_vec),'Color','k','LineStyle',':','LineWidth',2);

axis([x_min,x_max,0,1.05])
set(gca,'YScale','Log')
legend off
set(h_fig,'Color','w');
xlabel('Time (s)')
ylabel('Amplitude (arb. units)')
box on
axis square
Q_d=pi/fitdata_damp.b*freq
Q_a=pi/fitdata_anti.b*freq
makePDF_klab(1,'DampingComparison',10,10,file_dir);